#include "both.h"
#include "ab.h"
#include "mlist.h"

/*	bail
*	print the string to stderr and get outta here 
*
*/
void 
bail(s)
{
	fprintf(stderr,"%s\n");
	/*
	leave();
	*/
	exit(-1);
}

/*	mlistFindSer
*	find the mlist entry with the given serial number
*/

mlist *
mlistFindSer(m, serial)
mlist *m;
int serial;
{
	/* look through the list for the serial number */
	while(m) {
		if (m->serial == serial) return(m);
		m = m->next;
		}
	return(m);
}

/* 	
*	mdescAdd
*	add a message header to the given list
*/

int
mdescAdd(head, type, cnt, rc)
mdesc *head;
int type, cnt, rc;
{
	mdesc *tm;

	/* update the count */
	head->number++;

	/* get a new messge descriptor */
	tm = tmalloc(1, mdesc);
	if (! tm) bail("mdescAdd: out of memory");

	/* link it in at the tail */
	while(head->mdesc_next) {	/* find the end of the list */
		head = head->mdesc_next;
		}

	head->mdesc_next = tm;

	/* fill 'er up */
	tm->type 		= type;
	tm->number 		= cnt;
	tm->rc 			= rc;
	tm->mdesc_next 	= 0;
	
}

/*  sstring()
*
*   Malloc space for a string, copy into space.
*   Return a pointer to the space or NULL.
*/

char*
xab_sstring(s)
    char *s;
{
    int l;
    char *m;

    if (s) {
        l = strlen(s) + 1;
        m = (char*)malloc(l);
        bcopy(s, m, l);
        return m;
    } else
        return (char*)0;
}

/*  deftostr()
*
*   Return a string corresponding to the define given.
*/

char*
deftostr(def)
int def;
{
		switch(def) {
			case XAB_initsend:
				return("initsend");
				break;
			case XAB_putnint:
				return("putnint");
				break;
			case XAB_getnint:
				return("getnint");
				break;
			case XAB_putnshort:
				return("putnshort");
				break;
			case XAB_getnshort:
				return("getnshort");
				break;
			case XAB_putnlong:
				return("putnlong");
				break;
			case XAB_getnlong:
				return("getnlong");
				break;
			case XAB_putnfloat:
				return("putnfloat");
				break;
			case XAB_getnfloat:
				return("getnfloat");
				break;
			case XAB_putndfloat:
				return("putndfloat");
				break;
			case XAB_getndfloat:
				return("getndfloat");
				break;
			case XAB_putncplx:
				return("putncplx");
				break;
			case XAB_getncplx:
				return("getncplx");
				break;
			case XAB_putbytes:
				return("putbytes");
				break;
			case XAB_getbytes:
				return("getbytes");
				break;
			case XAB_putstring:
				return("putstring");
				break;
			case XAB_getstring:
				return("getstring");
				break;
			case XAB_barrier:
				return("barrier");
				break;
			case XAB_enroll:
				return("enroll");
				break;
			case XAB_initiate:
				return("initiate");
				break;
			case XAB_initiateM:
				return("initiateM");
				break;
			case XAB_leave:
				return("leave");
				break;
			case XAB_probe:
				return("probe");
				break;
			case XAB_pstatus:
				return("pstatus");
				break;
			case XAB_rcv:
				return("rcv");
				break;
			case XAB_vrcv:
				return("vrcv");
				break;
			case XAB_rcv_done:
				return("rcv_done");
				break;
			case XAB_vrcv_done:
				return("vrcv_done");
				break;
			case XAB_rcvmulti:
				return("rcvmulti");
				break;
			case XAB_rcvinfo:
				return("rcvinfo");
				break;
			case XAB_ready:
				return("ready");
				break;
			case XAB_snd:
				return("snd");
				break;
			case XAB_vsnd:
				return("vsnd");
				break;
			case XAB_status:
				return("status");
				break;
			case XAB_terminate:
				return("terminate");
				break;
			case XAB_waituntil:
				return("waituntil");
				break;
			case XAB_whoami:
				return("whoami");
				break;
			case XAB_initiate_done:	
				return("initiate_done");
				break;
			case XAB_initiateM_done:	
				return("initiate_done");
				break;
			case XAB_barrier_done:	
				return("barrier_done");
				break;
			case XAB_waituntil_done:	
				return("waituntil_done");
				break;
			default:
				return("no such define");
				break;

			} /* switch(def) */
}
